// Generated by dts-bundle-generator v9.5.1

/// <reference types="emscripten" />

export type FaustModuleFactory = EmscriptenModuleFactory<FaustModule>;
export interface FaustModule extends EmscriptenModule {
	ccall: typeof ccall;
	cwrap: typeof cwrap;
	UTF8ArrayToString(u8Array: number[], ptr: number, maxBytesToRead?: number): string;
	stringToUTF8Array(str: string, outU8Array: number[], outIdx: number, maxBytesToWrite: number): number;
	UTF8ToString: typeof UTF8ToString;
	UTF16ToString: typeof UTF16ToString;
	UTF32ToString: typeof UTF32ToString;
	stringToUTF8: typeof stringToUTF8;
	stringToUTF16: typeof stringToUTF16;
	stringToUTF32: typeof stringToUTF32;
	allocateUTF8: typeof allocateUTF8;
	lengthBytesUTF8: typeof lengthBytesUTF8;
	lengthBytesUTF16: typeof lengthBytesUTF16;
	lengthBytesUTF32: typeof lengthBytesUTF32;
	FS: typeof FS;
	libFaustWasm: new () => LibFaustWasm;
}
export type FaustInfoType = "help" | "version" | "libdir" | "includedir" | "archdir" | "dspdir" | "pathslist";
export interface IntVector {
	size(): number;
	get(i: number): number;
	delete(): void;
}
export interface FaustDspWasm {
	cfactory: number;
	data: IntVector;
	json: string;
}
export interface LibFaustWasm {
	/**
	 * Return the Faust compiler version.
	 *
	 * @returns the version
	 */
	version(): string;
	/**
	 * Create a dsp factory from Faust code.
	 *
	 * @param name - an arbitrary name for the Faust module
	 * @param code - Faust dsp code
	 * @param args - the compiler options
	 * @param useInternalMemory - tell the compiler to generate static embedded memory or not
	 * @returns an opaque reference to the factory
	 */
	createDSPFactory(name: string, code: string, args: string, useInternalMemory: boolean): FaustDspWasm;
	/**
	 * Delete a dsp factory.
	 *
	 * @param cFactory - the factory C++ internal pointer as a number
	 */
	deleteDSPFactory(cFactory: number): void;
	/**
	 * Expand Faust code i.e. linearize included libraries.
	 *
	 * @param name - an arbitrary name for the Faust module
	 * @param code - Faust dsp code
	 * @param args - the compiler options
	 * @returns return the expanded dsp code
	 */
	expandDSP(name: string, code: string, args: string): string;
	/**
	 * Generates auxiliary files from Faust code. The output depends on the compiler options.
	 *
	 * @param name - an arbitrary name for the faust module
	 * @param code - Faust dsp code
	 * @param args - the compiler options
	 */
	generateAuxFiles(name: string, code: string, args: string): boolean;
	/**
	 * Delete all existing dsp factories.
	 */
	deleteAllDSPFactories(): void;
	/**
	 * Exception management: gives an error string
	 */
	getErrorAfterException(): string;
	/**
	 * Exception management: cleanup
	 * Should be called after each exception generated by the LibFaust methods.
	 */
	cleanupAfterException(): void;
	/**
	 * Get info about the embedded Faust engine
	 * @param what - the requested info
	 */
	getInfos(what: FaustInfoType): string;
}
export interface FaustDspFactory extends Required<LooseFaustDspFactory> {
}
/**
 * The Factory structure.
 */
export interface LooseFaustDspFactory {
	/** a "pointer" (as an integer) on the internal C++ factory */
	cfactory?: number;
	/** the WASM code as a binary array */
	code?: Uint8Array;
	/** the compule WASM module */
	module: WebAssembly.Module;
	/** the compiled DSP JSON description */
	json: string;
	/** whether the factory is a polyphonic one or not */
	poly?: boolean;
	/** a unique identifier */
	shaKey?: string;
	/** a map of transferable audio buffers for the `soundfile` function */
	soundfiles?: Record<string, AudioData$1 | null>;
}
export interface FaustDspMeta {
	name: string;
	filename: string;
	compile_options: string;
	include_pathnames: string[];
	inputs: number;
	outputs: number;
	size: number;
	version: string;
	library_list: string[];
	meta: {
		[key: string]: string;
	}[];
	ui: FaustUIDescriptor;
}
export type FaustUIDescriptor = FaustUIGroup[];
export type FaustUIItem = FaustUIInputItem | FaustUIOutputItem | FaustUIGroup;
export interface FaustUIInputItem {
	type: FaustUIInputType;
	label: string;
	address: string;
	url: string;
	index: number;
	init?: number;
	min?: number;
	max?: number;
	step?: number;
	meta?: FaustUIMeta[];
}
export interface FaustUIOutputItem {
	type: FaustUIOutputType;
	label: string;
	address: string;
	index: number;
	min?: number;
	max?: number;
	meta?: FaustUIMeta[];
}
export interface FaustUIMeta {
	[order: number]: string;
	style?: string;
	unit?: string;
	scale?: "linear" | "exp" | "log";
	tooltip?: string;
	hidden?: string;
	[key: string]: string | undefined;
}
export type FaustUIGroupType = "vgroup" | "hgroup" | "tgroup";
export type FaustUIOutputType = "hbargraph" | "vbargraph";
export type FaustUIInputType = "vslider" | "hslider" | "button" | "checkbox" | "nentry" | "soundfile";
export interface FaustUIGroup {
	type: FaustUIGroupType;
	label: string;
	items: FaustUIItem[];
}
export type FaustUIType = FaustUIGroupType | FaustUIOutputType | FaustUIInputType;
export interface AudioParamDescriptor {
	automationRate?: AutomationRate;
	defaultValue?: number;
	maxValue?: number;
	minValue?: number;
	name: string;
}
export interface AudioWorkletProcessor {
	port: MessagePort;
	process(inputs: Float32Array[][], outputs: Float32Array[][], parameters: Record<string, Float32Array>): boolean;
}
export declare const AudioWorkletProcessor: {
	prototype: AudioWorkletProcessor;
	parameterDescriptors: AudioParamDescriptor[];
	new (options: AudioWorkletNodeOptions): AudioWorkletProcessor;
};
export interface AudioWorkletGlobalScope {
	AudioWorkletGlobalScope: any;
	globalThis: AudioWorkletGlobalScope;
	registerProcessor: (name: string, constructor: new (options: any) => AudioWorkletProcessor) => void;
	currentFrame: number;
	currentTime: number;
	sampleRate: number;
	AudioWorkletProcessor: typeof AudioWorkletProcessor;
}
export interface InterfaceFFT {
	forward(arr: ArrayLike<number> | ((arr: Float32Array) => any)): Float32Array;
	inverse(arr: ArrayLike<number> | ((arr: Float32Array) => any)): Float32Array;
	dispose(): void;
}
export declare const InterfaceFFT: {
	new (size: number): InterfaceFFT;
};
export type TWindowFunction = (index: number, length: number, ...args: any[]) => number;
export type Writeable<T> = {
	-readonly [P in keyof T]: T[P];
};
export type TypedArray = Int8Array | Uint8Array | Int16Array | Uint16Array | Int32Array | Uint32Array | Uint8ClampedArray | Float32Array | Float64Array;
export type TypedArrayConstructor = typeof Int8Array | typeof Uint8Array | typeof Int16Array | typeof Uint16Array | typeof Int32Array | typeof Uint32Array | typeof Uint8ClampedArray | typeof Float32Array | typeof Float64Array;
export declare const FFTUtils: {
	/** Inject window functions as array, no need to add rectangular (no windowing) */
	windowFunctions?: TWindowFunction[];
	/** Get a FFT interface constructor */
	getFFT: () => Promise<typeof InterfaceFFT>;
	/** Convert from FFTed (spectral) signal to three arrays for Faust processor's input, fft is readonly, real/imag/index length = *fftSize* / 2 + 1; fft length depends on the FFT implementation */
	fftToSignal: (fft: Float32Array | Float64Array, real: Float32Array | Float64Array, imag?: Float32Array | Float64Array, index?: Float32Array | Float64Array) => any;
	/** Convert from Faust processor's output to spectral data for Inversed FFT, real/imag are readonly, real/imag length = *fftSize* / 2 + 1; fft length depends on the FFT implementation */
	signalToFFT: (real: Float32Array | Float64Array, imag: Float32Array | Float64Array, fft: Float32Array | Float64Array) => any;
	/** Convert from Faust processor's output to direct audio output, real/imag are readonly, fft length = fftSize = (real/imag length - 1) * 2 */
	signalToNoFFT: (real: Float32Array | Float64Array, imag: Float32Array | Float64Array, fft: Float32Array | Float64Array) => any;
};
interface AudioData$1 {
	sampleRate: number;
	audioBuffer: Float32Array[];
}
export declare const FaustModuleFactoryFn: FaustModuleFactory;
export declare const FaustModuleFactoryWasm: Uint8Array<ArrayBufferLike>;
export declare const FaustModuleFactoryData: Uint8Array<ArrayBufferLike>;
/**
 * Instantiate `FaustModule` using bundled binaries. Module constructor and files can be overriden.
 */
export declare const instantiateFaustModule: (FaustModuleFactoryIn?: FaustModuleFactory, dataBinaryIn?: Uint8Array<ArrayBufferLike>, wasmBinaryIn?: Uint8Array<ArrayBufferLike>) => Promise<FaustModule>;
/**
 * Load libfaust-wasm files, than instantiate libFaust
 * @param jsFile path to `libfaust-wasm.js`
 * @param dataFile path to `libfaust-wasm.data`
 * @param wasmFile path to `libfaust-wasm.wasm`
 */
export declare const instantiateFaustModuleFromFile: (jsFile: string, dataFile?: string, wasmFile?: string) => Promise<FaustModule>;
declare class FaustAudioWorkletCommunicator {
	protected readonly port: MessagePort;
	protected readonly supportSharedArrayBuffer: boolean;
	protected readonly byteLength: number;
	protected uin8Invert: Uint8ClampedArray;
	protected uin8NewAccData: Uint8ClampedArray;
	protected uin8NewGyrData: Uint8ClampedArray;
	protected f32Acc: Float32Array;
	protected f32Gyr: Float32Array;
	constructor(port: MessagePort);
	initializeBuffer(ab: SharedArrayBuffer | ArrayBuffer): void;
	setNewAccDataAvailable(value: boolean): void;
	getNewAccDataAvailable(): boolean;
	setNewGyrDataAvailable(value: boolean): void;
	getNewGyrDataAvailable(): boolean;
	setAcc({ x, y, z }: {
		x: number;
		y: number;
		z: number;
	}, invert?: boolean): void;
	getAcc(): {
		x: number;
		y: number;
		z: number;
		invert: boolean;
	} | undefined;
	setGyr({ alpha, beta, gamma }: {
		alpha: number;
		beta: number;
		gamma: number;
	}): void;
	getGyr(): {
		alpha: number;
		beta: number;
		gamma: number;
	} | undefined;
}
declare class FaustAudioWorkletNodeCommunicator extends FaustAudioWorkletCommunicator {
	constructor(port: MessagePort);
}
declare class FaustAudioWorkletProcessorCommunicator extends FaustAudioWorkletCommunicator {
	constructor(port: MessagePort);
}
/**
 * The Faust wasm instance interface.
 */
export interface IFaustDspInstance {
	/**
	 * The dsp computation, to be called with successive input/output audio buffers.
	 *
	 * @param $dsp - the DSP pointer
	 * @param count - the audio buffer size in frames
	 * @param $inputs - the input audio buffer as in index in wasm memory
	 * @param $output - the output audio buffer as in index in wasm memory
	 */
	compute($dsp: number, count: number, $inputs: number, $output: number): void;
	/**
	 * Give the number of inputs of a Faust wasm instance.
	 *
	 * @param $dsp - the DSP pointer
	 */
	getNumInputs($dsp: number): number;
	/**
	 * Give the number of outputs of a Faust wasm instance.
	 *
	 * @param $dsp - the DSP pointer
	 */
	getNumOutputs($dsp: number): number;
	/**
	 * Give a parameter current value.
	 *
	 * @param $dsp - the DSP pointer
	 * @param index - the parameter index
	 * @return the parameter value
	 */
	getParamValue($dsp: number, index: number): number;
	/**
	 * Give the Faust wasm instance sample rate.
	 *
	 * @param $dsp - the DSP pointer
	 * @return the sample rate
	 */
	getSampleRate($dsp: number): number;
	/**
	 * Global init, calls the following methods:
	 * - static class 'classInit': static tables initialization
	 * - 'instanceInit': constants and instance state initialization
	 *
	 * @param $dsp - the DSP pointer
	 * @param sampleRate - the sampling rate in Hertz
	 */
	init($dsp: number, sampleRate: number): void;
	/** Init instance state (delay lines...).
	 *
	 * @param $dsp - the DSP pointer
	 */
	instanceClear($dsp: number): void;
	/** Init instance constant state.
	 *
	 * @param $dsp - the DSP pointer
	 * @param sampleRate - the sampling rate in Hertz
	 */
	instanceConstants($dsp: number, sampleRate: number): void;
	/** Init instance state.
	 *
	 * @param $dsp - the DSP pointer
	 * @param sampleRate - the sampling rate in Hertz
	 */
	instanceInit($dsp: number, sampleRate: number): void;
	/** Init default control parameters values.
	 *
	 * @param $dsp - the DSP pointer
	 */
	instanceResetUserInterface($dsp: number): void;
	/**
	 * Set a parameter current value.
	 *
	 * @param $dsp - the DSP pointer
	 * @param index - the parameter index
	 * @param value - the parameter value
	 */
	setParamValue($dsp: number, index: number, value: number): void;
}
/**
 * Mixer used in polyphonic mode.
 */
export interface IFaustMixerInstance {
	clearOutput(bufferSize: number, chans: number, $outputs: number): void;
	mixCheckVoice(bufferSize: number, chans: number, $inputs: number, $outputs: number): number;
	fadeOut(bufferSize: number, chans: number, $outputs: number): void;
}
/**
 * Monophonic instance.
 */
export interface FaustMonoDspInstance {
	memory: WebAssembly.Memory;
	api: IFaustDspInstance;
	json: string;
}
/**
 * Polyphonic instance.
 */
export interface FaustPolyDspInstance {
	memory: WebAssembly.Memory;
	voices: number;
	voiceAPI: IFaustDspInstance;
	effectAPI?: IFaustDspInstance;
	mixerAPI: IFaustMixerInstance;
	voiceJSON: string;
	effectJSON?: string;
}
export declare class FaustDspInstance implements IFaustDspInstance {
	private readonly fExports;
	constructor(exports: IFaustDspInstance);
	compute($dsp: number, count: number, $input: number, $output: number): void;
	getNumInputs($dsp: number): number;
	getNumOutputs($dsp: number): number;
	getParamValue($dsp: number, index: number): number;
	getSampleRate($dsp: number): number;
	init($dsp: number, sampleRate: number): void;
	instanceClear($dsp: number): void;
	instanceConstants($dsp: number, sampleRate: number): void;
	instanceInit($dsp: number, sampleRate: number): void;
	instanceResetUserInterface($dsp: number): void;
	setParamValue($dsp: number, index: number, value: number): void;
}
export declare class FaustWasmInstantiator {
	private static createWasmImport;
	private static createWasmMemoryPoly;
	private static createWasmMemoryMono;
	private static createMonoDSPInstanceAux;
	private static createMemoryMono;
	private static createMemoryPoly;
	private static createMixerAux;
	static loadDSPFactory(wasmPath: string, jsonPath: string): Promise<FaustDspFactory>;
	static loadDSPMixer(mixerPath: string, fs?: typeof FS): Promise<WebAssembly.Module>;
	static createAsyncMonoDSPInstance(factory: LooseFaustDspFactory): Promise<FaustMonoDspInstance>;
	static createSyncMonoDSPInstance(factory: LooseFaustDspFactory): FaustMonoDspInstance;
	static createAsyncPolyDSPInstance(voiceFactory: LooseFaustDspFactory, mixerModule: WebAssembly.Module, voices: number, effectFactory?: LooseFaustDspFactory): Promise<FaustPolyDspInstance>;
	static createSyncPolyDSPInstance(voiceFactory: LooseFaustDspFactory, mixerModule: WebAssembly.Module, voices: number, effectFactory?: LooseFaustDspFactory): FaustPolyDspInstance;
}
export type OutputParamHandler = (path: string, value: number) => void;
export type ComputeHandler = (buffer_size: number) => void;
export type PlotHandler = (plotted: Float32Array[] | Float64Array[], index: number, events?: {
	type: string;
	data: any;
}[]) => void;
export type MetadataHandler = (key: string, value: string) => void;
export type UIHandler = (item: FaustUIItem) => void;
export type SensorEventHandler = (val: number) => void;
export type SensorEventHandlers = {
	x: SensorEventHandler[];
	y: SensorEventHandler[];
	z: SensorEventHandler[];
};
/** Definition of the AudioBufferItem type */
export interface AudioBufferItem {
	pathName: string;
	audioBuffer: AudioBuffer;
}
/** Definition of the SoundfileItem type */
export interface SoundfileItem {
	/** Name of the soundfile */
	name: string;
	/** URL of the soundfile */
	url: string;
	/** Index in the DSP struct */
	index: number;
	/** Base pointer in wasm memory */
	basePtr: number;
}
/**
 * WasmAllocator is a basic memory management class designed to allocate
 * blocks of memory within a WebAssembly.Memory object. It provides a simple
 * alloc method to allocate a contiguous block of memory of a specified size.
 *
 * The allocator operates by keeping a linear progression through the memory,
 * always allocating the next block at the end of the last. This approach does not
 * handle freeing of memory or reuse of memory spaces.
 */
export declare class WasmAllocator {
	private readonly memory;
	private allocatedBytes;
	constructor(memory: WebAssembly.Memory, offset: number);
	/**
	 * Allocates a block of memory of the specified size, returning the pointer to the
	 * beginning of the block. The block is allocated at the current offset and the
	 * offset is incremented by the size of the block.
	 *
	 * @param sizeInBytes The size of the block to allocate in bytes.
	 * @returns The offset (pointer) to the beginning of the allocated block.
	 */
	alloc(sizeInBytes: number): number;
	/**
	 * Returns the underlying buffer object.
	 *
	 * @returns The buffer object.
	 */
	getBuffer(): ArrayBuffer;
	/**
	 * Returns the Int32 view of the underlying buffer object.
	 *
	 * @returns The view of the memory buffer as Int32Array.
	 */
	getInt32Array(): Int32Array;
	/**
	 * Returns the Int64 view of the underlying buffer object.
	 *
	 * @returns The view of the memory buffer as BigInt64Array.
	 */
	getInt64Array(): BigInt64Array;
	/**
	 * Returns the Float32 view of the underlying buffer object.
	 *
	 * @returns The view of the memory buffer as Float32Array.
	 */
	getFloat32Array(): Float32Array;
	/**
	 * Returns the Float64 view of the underlying buffer object..
	 *
	 * @returns The view of the memory buffer as Float64Array.
	 */
	getFloat64Array(): Float64Array;
}
/**
 * Soundfile class to handle soundfile data in wasm memory.
 */
export declare class Soundfile {
	/** Maximum number of soundfile parts. */
	static get MAX_SOUNDFILE_PARTS(): number;
	/** Maximum number of channels. */
	static get MAX_CHAN(): number;
	/** Maximum buffer size in frames. */
	static get BUFFER_SIZE(): number;
	/** Default sample rate. */
	static get SAMPLE_RATE(): number;
	/** Pointer to the soundfile structure in wasm memory */
	private readonly fPtr;
	private readonly fBuffers;
	private readonly fLength;
	private readonly fSR;
	private readonly fOffset;
	private readonly fSampleSize;
	private readonly fPtrSize;
	private readonly fIntSize;
	private readonly fAllocator;
	constructor(allocator: WasmAllocator, sampleSize: number, curChan: number, length: number, maxChan: number, totalParts: number);
	private allocBuffers;
	shareBuffers(curChan: number, maxChan: number): void;
	copyToOut(part: number, maxChannels: number, offset: number, audioData: AudioData$1): void;
	copyToOutReal32(maxChannels: number, offset: number, audioData: AudioData$1): void;
	copyToOutReal64(maxChannels: number, offset: number, audioData: AudioData$1): void;
	emptyFile(part: number, offset: number): number;
	displayMemory(where?: string, mem?: boolean): void;
	getPtr(): number;
	getHEAP32(): Int32Array;
	getHEAPFloat32(): Float32Array;
	getHEAPFloat64(): Float64Array;
}
/**
 * DSP implementation that mimic the C++ 'dsp' class:
 * - adding MIDI control: metadata are decoded and incoming MIDI messages will control the associated controllers
 * - an output handler can be set to treat produced output controllers (like 'bargraph')
 * - regular controllers are handled using setParamValue/getParamValue and getParams methods
 */
export interface IFaustBaseWebAudioDsp {
	/**
	 * Set the parameter output handler, to  be called in the 'compute' method with output parameters (like bargraph).
	 *
	 * @param handler - the output handler
	 */
	setOutputParamHandler(handler: OutputParamHandler | null): void;
	/**
	 * Get the parameter output handler.
	 *
	 * @return the current output handler
	 */
	getOutputParamHandler(): OutputParamHandler | null;
	/**
	 * Call the output parameter handler with a path and value.
	 *
	 * @param path - the path to the wanted parameter (retrieved using 'getParams' method)
	 * @param value - the float value for the wanted control
	 */
	callOutputParamHandler(path: string, value: number): void;
	/**
	 * Set the compute handler, to  be called in the 'compute' method with buffer size.
	 *
	 * @param handler - the compute handler
	 */
	setComputeHandler(handler: ComputeHandler | null): void;
	/**
	 * Get the compute handler.
	 *
	 * @return the current output handler
	 */
	getComputeHandler(): ComputeHandler | null;
	/**
	 * Set the plot handler, to  be called in the 'compute' method with various info (see PlotHandler type).
	 *
	 * @param handler - the plot handler
	 */
	setPlotHandler(handler: PlotHandler | null): void;
	/**
	 * Get the plot handler.
	 *
	 * @return the current plot handler
	 */
	getPlotHandler(): PlotHandler | null;
	/**
	 * Return instance number of audio inputs.
	 *
	 * @return the instance number of audio inputs
	 */
	getNumInputs(): number;
	/**
	 * Return instance number of audio outputs.
	 *
	 * @return the instance number of audio outputs
	 */
	getNumOutputs(): number;
	/**
	 * DSP instance computation, to be called with successive input/output audio buffers, using their size.
	 *
	 * @param inputs - the input audio buffers
	 * @param outputs - the output audio buffers
	 */
	compute(inputs: Float32Array[], outputs: Float32Array[]): boolean;
	/**
	 * Give a handler to be called on 'declare key value' kind of metadata.
	 *
	 * @param handler - the handler to be used
	 */
	metadata(handler: MetadataHandler): void;
	/**
	 * Handle untyped MIDI messages.
	 *
	 * @param data - and arry of MIDI bytes
	 */
	midiMessage(data: number[] | Uint8Array): void;
	/**
	 * Handle MIDI ctrlChange messages.
	 *
	 * @param channel - the MIDI channel (0..15, not used for now)
	 * @param ctrl - the MIDI controller number (0..127)
	 * @param value - the MIDI controller value (0..127)
	 */
	ctrlChange(chan: number, ctrl: number, value: number): void;
	/**
	 * Handle MIDI pitchWheel messages.
	 *
	 * @param channel - the MIDI channel (0..15, not used for now)
	 * @param value - the MIDI controller value (0..16383)
	 */
	pitchWheel(chan: number, value: number): void;
	/**
	 * Handle MIDI keyOn messages.
	 * @param channel
	 * @param pitch
	 * @param velocity
	 */
	keyOn(channel: number, pitch: number, velocity: number): void;
	/**
	 * Handle MIDI keyOn messages.
	 * @param channel
	 * @param pitch
	 * @param velocity
	 */
	keyOff(channel: number, pitch: number, velocity: number): void;
	/**
	 * Set parameter value.
	 *
	 * @param path - the path to the wanted parameter (retrieved using 'getParams' method)
	 * @param val - the float value for the wanted control
	 */
	setParamValue(path: string, value: number): void;
	/**
	 * Get parameter value.
	 *
	 * @param path - the path to the wanted parameter (retrieved using 'getParams' method)
	 *
	 * @return the float value
	 */
	getParamValue(path: string): number;
	/**
	 * Get the table of all input parameters paths.
	 *
	 * @return the table of all input parameters paths
	 */
	getParams(): string[];
	/**
	 * Get DSP JSON description with its UI and metadata as object.
	 *
	 * @return the DSP JSON description as object
	 */
	getMeta(): FaustDspMeta;
	/**
	 * Get DSP UI description.
	 *
	 * @return the DSP UI description
	 */
	getUI(): FaustUIDescriptor;
	/**
	* Get DSP UI items description.
	*
	* @return the DSP UI items description
	*/
	getDescriptors(): FaustUIInputItem[];
	/**
	 * Get DSP JSON description with its UI and metadata.
	 *
	 * @return the DSP JSON description
	 */
	getJSON(): string;
	/**
	* Start accelerometer and gyroscope handlers.
	*/
	startSensors(): void;
	/**
	 * Stop accelerometer and gyroscope handlers.
	 */
	stopSensors(): void;
	/** Indicating if the DSP handles the accelerometer */
	readonly hasAccInput: boolean;
	/**
	 * Accelerometer handling.
	 * accelerationIncludingGravity: DeviceMotionEvent["accelerationIncludingGravity"]
	 * invert: boolean
	 */
	propagateAcc(accelerationIncludingGravity: NonNullable<DeviceMotionEvent["accelerationIncludingGravity"]>, invert: boolean): void;
	/** Indicating if the DSP handles the gyroscope */
	readonly hasGyrInput: boolean;
	/**
	 * Gyroscope handling.
	 * event: Pick<DeviceOrientationEvent, "alpha" | "beta" | "gamma">
	 */
	propagateGyr(event: Pick<DeviceOrientationEvent, "alpha" | "beta" | "gamma">): void;
	/**
	 * Start the DSP audio processing.
	 */
	start(): void;
	/**
	 * Stop the DSP audio processing.
	 */
	stop(): void;
	/**
	 * Destroy the DSP.
	 */
	destroy(): void;
}
export interface IFaustMonoWebAudioDsp extends IFaustBaseWebAudioDsp {
}
export interface IFaustMonoWebAudioNode extends IFaustMonoWebAudioDsp, AudioNode {
}
export interface IFaustPolyWebAudioDsp extends IFaustBaseWebAudioDsp {
	/**
	 * Handle MIDI keyOn messages.
	 *
	 * @param channel - the MIDI channel (0..15, not used for now)
	 * @param pitch - the MIDI pitch value (0..127)
	 * @param velocity - the MIDI velocity value (0..127)
	 */
	keyOn(channel: number, pitch: number, velocity: number): void;
	/**
	 * Handle MIDI keyOff messages.
	 *
	 * @param channel - the MIDI channel (0..15, not used for now)
	 * @param pitch - the MIDI pitch value (0..127)
	 * @param velocity - the MIDI velocity value (0..127)
	 */
	keyOff(channel: number, pitch: number, velocity: number): void;
	/**
	 * Stop all playing notes.
	 *
	 * @param hard - whether to immediately stop notes or put them in release mode
	 */
	allNotesOff(hard: boolean): void;
}
export interface IFaustPolyWebAudioNode extends IFaustPolyWebAudioDsp, AudioNode {
}
export declare class FaustBaseWebAudioDsp implements IFaustBaseWebAudioDsp {
	protected fOutputHandler: OutputParamHandler | null;
	protected fComputeHandler: ComputeHandler | null;
	protected fPlotHandler: PlotHandler | null;
	protected fCachedEvents: {
		type: string;
		data: any;
	}[];
	protected fBufferNum: number;
	protected fInChannels: Float32Array[] | Float64Array[];
	protected fOutChannels: Float32Array[] | Float64Array[];
	protected fOutputsTimer: number;
	protected fInputsItems: string[];
	protected fOutputsItems: string[];
	protected fDescriptor: FaustUIInputItem[];
	protected fSoundfiles: SoundfileItem[];
	protected fSoundfileBuffers: LooseFaustDspFactory["soundfiles"];
	/** Keep the end of memory offset before soundfiles */
	protected fEndMemory: number;
	protected fAcc: SensorEventHandlers;
	protected fGyr: SensorEventHandlers;
	protected fAudioInputs: number;
	protected fAudioOutputs: number;
	protected fBufferSize: number;
	protected fPtrSize: number;
	protected fSampleSize: number;
	protected fPitchwheelLabel: {
		path: string;
		chan: number;
		min: number;
		max: number;
	}[];
	protected fCtrlLabel: {
		path: string;
		chan: number;
		min: number;
		max: number;
	}[][];
	protected fMidiKeyLabel: {
		path: string;
		chan: number;
		min: number;
		max: number;
	}[][];
	protected fMidiKeyOnLabel: {
		path: string;
		chan: number;
		min: number;
		max: number;
	}[][];
	protected fMidiKeyOffLabel: {
		path: string;
		chan: number;
		min: number;
		max: number;
	}[][];
	protected fPathTable: {
		[address: string]: number;
	};
	protected fUICallback: UIHandler;
	protected fProcessing: boolean;
	protected fDestroyed: boolean;
	protected fFirstCall: boolean;
	protected fJSONDsp: FaustDspMeta;
	constructor(sampleSize: number, bufferSize: number, soundfiles: LooseFaustDspFactory["soundfiles"]);
	static remap(v: number, mn0: number, mx0: number, mn1: number, mx1: number): number;
	static parseUI(ui: FaustUIDescriptor, callback: (item: FaustUIItem) => any): void;
	static parseGroup(group: FaustUIGroup, callback: (item: FaustUIItem) => any): void;
	static parseItems(items: FaustUIItem[], callback: (item: FaustUIItem) => any): void;
	static parseItem(item: FaustUIItem, callback: (item: FaustUIItem) => any): void;
	/** Split the soundfile names and return an array of names */
	static splitSoundfileNames(input: string): string[];
	get hasAccInput(): boolean;
	propagateAcc(accelerationIncludingGravity: NonNullable<DeviceMotionEvent["accelerationIncludingGravity"]>, invert?: boolean): void;
	get hasGyrInput(): boolean;
	propagateGyr(event: Pick<DeviceOrientationEvent, "alpha" | "beta" | "gamma">): void;
	/** Build the accelerometer handler */
	private setupAccHandler;
	/** Build the gyroscope handler */
	private setupGyrHandler;
	static extractUrlsFromMeta(dspMeta: FaustDspMeta): string[];
	/**
	 * Load a soundfile possibly containing several parts in the DSP struct.
	 * Soundfile pointers are located at 'index' offset, to be read in the JSON file.
	 * The DSP struct is located at baseDSP in the wasm memory,
	 * either a monophonic DSP, or a voice in a polyphonic context.
	 *
	 * @param allocator : the wasm memory allocator
	 * @param baseDSP : the base DSP in the wasm memory
	 * @param name : the name of the soundfile
	 * @param url : the url of the soundfile
	 */
	private loadSoundfile;
	createSoundfile(allocator: WasmAllocator, soundfileIdList: string[], soundfiles: LooseFaustDspFactory["soundfiles"], maxChan?: number): Soundfile;
	/**
	 * Init soundfiles memory.
	 *
	 * @param allocator : the wasm memory allocator
	 * @param baseDSP : the DSP struct (either a monophonic DSP of polyphonic voice) base DSP in the wasm memory
	*/
	protected initSoundfileMemory(allocator: WasmAllocator, baseDSP: number): void;
	protected updateOutputs(): void;
	metadata(handler: MetadataHandler): void;
	compute(input: Float32Array[], output: Float32Array[]): boolean;
	setOutputParamHandler(handler: OutputParamHandler | null): void;
	getOutputParamHandler(): OutputParamHandler | null;
	callOutputParamHandler(path: string, value: number): void;
	setComputeHandler(handler: ComputeHandler | null): void;
	getComputeHandler(): ComputeHandler | null;
	setPlotHandler(handler: PlotHandler | null): void;
	getPlotHandler(): PlotHandler | null;
	getNumInputs(): number;
	getNumOutputs(): number;
	midiMessage(data: number[] | Uint8Array): void;
	ctrlChange(channel: number, ctrl: number, value: number): void;
	keyOn(channel: number, pitch: number, velocity: number): void;
	keyOff(channel: number, pitch: number, velocity: number): void;
	pitchWheel(channel: number, wheel: number): void;
	setParamValue(path: string, value: number): void;
	getParamValue(path: string): number;
	getParams(): string[];
	getMeta(): FaustDspMeta;
	getJSON(): string;
	getUI(): FaustUIDescriptor;
	getDescriptors(): FaustUIInputItem[];
	hasSoundfiles(): boolean;
	startSensors(): void;
	stopSensors(): void;
	start(): void;
	stop(): void;
	destroy(): void;
}
export declare class FaustMonoWebAudioDsp extends FaustBaseWebAudioDsp implements IFaustMonoWebAudioDsp {
	private fInstance;
	private fDSP;
	constructor(instance: FaustMonoDspInstance, sampleRate: number, sampleSize: number, bufferSize: number, soundfiles: LooseFaustDspFactory["soundfiles"]);
	private initMemory;
	toString(): string;
	compute(input: Float32Array[] | ((input: Float32Array[] | Float64Array[]) => any), output: Float32Array[] | ((output: Float32Array[] | Float64Array[]) => any)): boolean;
	metadata(handler: MetadataHandler): void;
	getNumInputs(): number;
	getNumOutputs(): number;
	setParamValue(path: string, value: number): void;
	getParamValue(path: string): number;
	getMeta(): FaustDspMeta;
	getJSON(): string;
	getDescriptors(): FaustUIInputItem[];
	getUI(): FaustUIDescriptor;
}
export declare class FaustWebAudioDspVoice {
	static get kActiveVoice(): number;
	static get kFreeVoice(): number;
	static get kReleaseVoice(): number;
	static get kLegatoVoice(): number;
	static get kNoVoice(): number;
	static get VOICE_STOP_LEVEL(): number;
	private fFreqLabel;
	private fGateLabel;
	private fGainLabel;
	private fKeyLabel;
	private fVelLabel;
	private fDSP;
	private fAPI;
	fCurNote: number;
	fNextNote: number;
	fNextVel: number;
	fDate: number;
	fLevel: number;
	constructor($dsp: number, api: IFaustDspInstance, inputItems: string[], pathTable: {
		[address: string]: number;
	}, sampleRate: number);
	static midiToFreq(note: number): number;
	static normalizeVelocity(velocity: number): number;
	private extractPaths;
	keyOn(pitch: number, velocity: number, legato?: boolean): void;
	keyOff(hard?: boolean): void;
	computeLegato(bufferSize: number, $inputs: number, $outputZero: number, $outputsHalf: number): void;
	compute(bufferSize: number, $inputs: number, $outputs: number): void;
	setParamValue(index: number, value: number): void;
	getParamValue(index: number): number;
}
export declare class FaustPolyWebAudioDsp extends FaustBaseWebAudioDsp implements IFaustPolyWebAudioDsp {
	private fInstance;
	private fEffect;
	private fJSONEffect;
	private fAudioMixing;
	private fAudioMixingHalf;
	private fVoiceTable;
	constructor(instance: FaustPolyDspInstance, sampleRate: number, sampleSize: number, bufferSize: number, soundfiles: LooseFaustDspFactory["soundfiles"]);
	private initMemory;
	toString(): string;
	private allocVoice;
	private getPlayingVoice;
	private getFreeVoice;
	compute(input: Float32Array[], output: Float32Array[]): boolean;
	getNumInputs(): number;
	getNumOutputs(): number;
	private static findPath;
	setParamValue(path: string, value: number): void;
	getParamValue(path: string): number;
	getMeta(): FaustDspMeta;
	getJSON(): string;
	getUI(): FaustUIDescriptor;
	getDescriptors(): FaustUIInputItem[];
	midiMessage(data: number[] | Uint8Array): void;
	ctrlChange(channel: number, ctrl: number, value: number): void;
	keyOn(channel: number, pitch: number, velocity: number): void;
	keyOff(channel: number, pitch: number, velocity: number): void;
	allNotesOff(hard?: boolean): void;
}
/**
 * Injected in the string to be compiled on AudioWorkletProcessor side
 */
export interface FaustData {
	processorName: string;
	dspName: string;
	dspMeta: FaustDspMeta;
	poly: boolean;
	effectMeta?: FaustDspMeta;
}
export interface FaustAudioWorkletProcessorDependencies<Poly extends boolean = false> {
	FaustBaseWebAudioDsp: typeof FaustBaseWebAudioDsp;
	FaustMonoWebAudioDsp: Poly extends true ? undefined : typeof FaustMonoWebAudioDsp;
	FaustPolyWebAudioDsp: Poly extends true ? typeof FaustPolyWebAudioDsp : undefined;
	FaustWebAudioDspVoice: Poly extends true ? typeof FaustWebAudioDspVoice : undefined;
	FaustWasmInstantiator: typeof FaustWasmInstantiator;
	FaustAudioWorkletProcessorCommunicator: typeof FaustAudioWorkletProcessorCommunicator;
}
export interface FaustAudioWorkletNodeOptions<Poly extends boolean = false> extends AudioWorkletNodeOptions {
	processorOptions: Poly extends true ? FaustPolyAudioWorkletProcessorOptions : FaustMonoAudioWorkletProcessorOptions;
}
export interface FaustMonoAudioWorkletNodeOptions extends AudioWorkletNodeOptions {
	processorOptions: FaustMonoAudioWorkletProcessorOptions;
}
export interface FaustPolyAudioWorkletNodeOptions extends AudioWorkletNodeOptions {
	processorOptions: FaustPolyAudioWorkletProcessorOptions;
}
export interface FaustAudioWorkletProcessorOptions {
	name: string;
	sampleSize: number;
	moduleId?: string;
	instanceId?: string;
}
export interface FaustMonoAudioWorkletProcessorOptions extends FaustAudioWorkletProcessorOptions {
	factory: LooseFaustDspFactory;
}
export interface FaustPolyAudioWorkletProcessorOptions extends FaustAudioWorkletProcessorOptions {
	voiceFactory: LooseFaustDspFactory;
	mixerModule: WebAssembly.Module;
	voices: number;
	effectFactory?: LooseFaustDspFactory;
}
export declare const getFaustAudioWorkletProcessor: <Poly extends boolean = false>(dependencies: FaustAudioWorkletProcessorDependencies<Poly>, faustData: FaustData, register?: boolean) => {
	new (options: AudioWorkletNodeOptions): AudioWorkletProcessor;
	prototype: AudioWorkletProcessor;
	parameterDescriptors: AudioParamDescriptor[];
};
export interface FaustFFTOptionsData {
	fftSize: number;
	fftOverlap: number;
	noIFFT: boolean;
	/** Index number of the default window function, leave undefined or -1 for rectangular (no windowing) */
	defaultWindowFunction: number;
}
/**
 * Injected in the string to be compiled on AudioWorkletProcessor side
 */
export interface FaustFFTData {
	processorName: string;
	dspName: string;
	dspMeta: FaustDspMeta;
	fftOptions?: Partial<FaustFFTOptionsData>;
}
export interface FaustFFTAudioWorkletProcessorDependencies {
	FaustBaseWebAudioDsp: typeof FaustBaseWebAudioDsp;
	FaustMonoWebAudioDsp: typeof FaustMonoWebAudioDsp;
	FaustWasmInstantiator: typeof FaustWasmInstantiator;
	FaustAudioWorkletProcessorCommunicator: typeof FaustAudioWorkletProcessorCommunicator;
	FFTUtils: typeof FFTUtils;
}
export interface FaustFFTAudioWorkletNodeOptions extends AudioWorkletNodeOptions {
	processorOptions: FaustFFTAudioWorkletProcessorOptions;
}
export interface FaustFFTAudioWorkletProcessorOptions {
	name: string;
	sampleSize: number;
	factory: LooseFaustDspFactory;
	moduleId?: string;
	instanceId?: string;
}
export declare const getFaustFFTAudioWorkletProcessor: (dependencies: FaustFFTAudioWorkletProcessorDependencies, faustData: FaustFFTData, register?: boolean) => {
	new (options: AudioWorkletNodeOptions): AudioWorkletProcessor;
	prototype: AudioWorkletProcessor;
	parameterDescriptors: AudioParamDescriptor[];
};
export interface ILibFaust extends LibFaustWasm {
	module(): FaustModule;
	fs(): typeof FS;
}
export declare class LibFaust implements ILibFaust {
	private fModule;
	private fCompiler;
	private fFileSystem;
	constructor(module: FaustModule);
	module(): FaustModule;
	fs(): typeof FS;
	version(): string;
	createDSPFactory(name: string, code: string, args: string, useInternalMemory: boolean): FaustDspWasm;
	deleteDSPFactory(cFactory: number): void;
	expandDSP(name: string, code: string, args: string): string;
	generateAuxFiles(name: string, code: string, args: string): boolean;
	deleteAllDSPFactories(): void;
	getErrorAfterException(): string;
	cleanupAfterException(): void;
	getInfos(what: FaustInfoType): string;
	toString(): string;
}
export declare const ab2str: (buf: Uint8Array) => any;
export declare const str2ab: (str: string) => Uint8Array<ArrayBuffer>;
export interface IFaustCompiler {
	/**
	 * Gives the Faust compiler version.
	 * @return a version string
	 */
	version(): string;
	/**
	 * Gives the last compilation error.
	 * @return an error string
	 */
	getErrorMessage(): string;
	/**
	 * Create a wasm factory from Faust code i.e. wasm compiled code, to be used to create monophonic instances.
	 * This function is running asynchronously.
	 *
	 * @param name - an arbitrary name for the Faust factory
	 * @param code - Faust dsp code
	 * @param args - the compiler options
	 * @returns returns the wasm factory
	 */
	createMonoDSPFactory(name: string, code: string, args: string): Promise<FaustDspFactory | null>;
	/**
	 * Create a wasm factory from Faust code i.e. wasm compiled code, to be used to create polyphonic instances.
	 * This function is running asynchronously.
	 *
	 * @param name - an arbitrary name for the Faust factory
	 * @param code - Faust dsp code
	 * @param args - the compiler options
	 * @returns returns the wasm factory
	 */
	createPolyDSPFactory(name: string, code: string, args: string): Promise<FaustDspFactory | null>;
	/**
	 * Delete a dsp factory.
	 *
	 * @param factory - the factory to be deleted
	 */
	deleteDSPFactory(factory: FaustDspFactory): void;
	/**
	 * Expand Faust code i.e. linearize included libraries.
	 *
	 * @param code - Faust dsp code
	 * @param args - the compiler options
	 * @returns returns the expanded dsp code
	 */
	expandDSP(code: string, args: string): string | null;
	/**
	 * Generates auxiliary files from Faust code. The output depends on the compiler options.
	 *
	 * @param name - an arbitrary name for the Faust module
	 * @param code - Faust dsp code
	 * @param args - the compiler options
	 * @returns whether the generation actually succeded
	 */
	generateAuxFiles(name: string, code: string, args: string): boolean;
	/**
	 * Delete all factories.
	 */
	deleteAllDSPFactories(): void;
	fs(): typeof FS;
	getAsyncInternalMixerModule(isDouble?: boolean): Promise<{
		mixerBuffer: Uint8Array;
		mixerModule: WebAssembly.Module;
	}>;
	getSyncInternalMixerModule(isDouble?: boolean): {
		mixerBuffer: Uint8Array;
		mixerModule: WebAssembly.Module;
	};
}
export declare class FaustCompiler implements IFaustCompiler {
	private fLibFaust;
	private fErrorMessage;
	private static gFactories;
	private mixer32Buffer;
	private mixer64Buffer;
	private mixer32Module;
	private mixer64Module;
	/**
	 * Get a stringified DSP factories table
	 */
	static serializeDSPFactories(): Record<string, {
		code: string;
		json: any;
		poly: boolean;
	}>;
	/**
	 * Get a stringified DSP factories table as string
	 */
	static stringifyDSPFactories(): string;
	/**
	 * Import a DSP factories table
	 */
	static deserializeDSPFactories(table: Record<string, {
		code: string;
		json: any;
		poly: boolean;
	}>): Promise<Map<string, FaustDspFactory>[]>;
	/**
	 * Import a stringified DSP factories table
	 */
	static importDSPFactories(tableStr: string): Promise<Map<string, FaustDspFactory>[]>;
	constructor(libFaust: ILibFaust);
	private intVec2intArray;
	private createDSPFactory;
	version(): string;
	getErrorMessage(): string;
	createMonoDSPFactory(name: string, code: string, args: string): Promise<FaustDspFactory | null>;
	createPolyDSPFactory(name: string, code: string, args: string): Promise<FaustDspFactory | null>;
	deleteDSPFactory(factory: FaustDspFactory): void;
	expandDSP(code: string, args: string): string;
	generateAuxFiles(name: string, code: string, args: string): boolean;
	deleteAllDSPFactories(): void;
	fs(): typeof FS;
	getAsyncInternalMixerModule(isDouble?: boolean): Promise<{
		mixerBuffer: Uint8Array<ArrayBufferLike>;
		mixerModule: WebAssembly.Module;
	}>;
	getSyncInternalMixerModule(isDouble?: boolean): {
		mixerBuffer: Uint8Array<ArrayBufferLike>;
		mixerModule: WebAssembly.Module;
	};
}
/**
 *  For offline rendering.
 */
export interface IFaustOfflineProcessor extends IFaustBaseWebAudioDsp {
	render(inputs?: Float32Array[], length?: number, onUpdate?: (sample: number) => any): Float32Array[];
}
export interface IFaustMonoOfflineProcessor extends IFaustOfflineProcessor, IFaustMonoWebAudioDsp {
}
export interface IFaustPolyOfflineProcessor extends IFaustOfflineProcessor, IFaustPolyWebAudioDsp {
}
export declare class FaustOfflineProcessor<Poly extends boolean = false> {
	protected fDSPCode: Poly extends true ? FaustPolyWebAudioDsp : FaustMonoWebAudioDsp;
	protected fBufferSize: number;
	protected fInputs: Float32Array[];
	protected fOutputs: Float32Array[];
	constructor(instance: Poly extends true ? FaustPolyWebAudioDsp : FaustMonoWebAudioDsp, bufferSize: number);
	getParameterDescriptors(): AudioParamDescriptor[];
	compute(input: Float32Array[], output: Float32Array[]): boolean;
	setOutputParamHandler(handler: OutputParamHandler): void;
	getOutputParamHandler(): OutputParamHandler | null;
	callOutputParamHandler(path: string, value: number): void;
	setComputeHandler(handler: ComputeHandler): void;
	getComputeHandler(): ComputeHandler | null;
	setPlotHandler(handler: PlotHandler): void;
	getPlotHandler(): PlotHandler | null;
	getNumInputs(): number;
	getNumOutputs(): number;
	metadata(handler: MetadataHandler): void;
	midiMessage(data: number[] | Uint8Array): void;
	ctrlChange(chan: number, ctrl: number, value: number): void;
	pitchWheel(chan: number, value: number): void;
	keyOn(channel: number, pitch: number, velocity: number): void;
	keyOff(channel: number, pitch: number, velocity: number): void;
	setParamValue(path: string, value: number): void;
	getParamValue(path: string): number;
	getParams(): string[];
	getMeta(): FaustDspMeta;
	getJSON(): string;
	getDescriptors(): FaustUIInputItem[];
	getUI(): FaustUIDescriptor;
	start(): void;
	stop(): void;
	destroy(): void;
	get hasAccInput(): boolean;
	propagateAcc(accelerationIncludingGravity: NonNullable<DeviceMotionEvent["accelerationIncludingGravity"]>, invert?: boolean): void;
	get hasGyrInput(): boolean;
	propagateGyr(event: Pick<DeviceOrientationEvent, "alpha" | "beta" | "gamma">): void;
	startSensors(): void;
	stopSensors(): void;
	/**
	 * Render frames in an array.
	 *
	 * @param inputs - input signal
	 * @param length - the number of frames to render (default: bufferSize)
	 * @param onUpdate - a callback after each buffer calculated, with an argument "current sample"
	 * @return an array of Float32Array with the rendered frames
	 */
	render(inputs?: Float32Array[], length?: number, onUpdate?: (sample: number) => any): Float32Array[];
}
export declare class FaustMonoOfflineProcessor extends FaustOfflineProcessor<false> implements IFaustMonoWebAudioDsp {
}
export declare class FaustPolyOfflineProcessor extends FaustOfflineProcessor<true> implements IFaustPolyWebAudioDsp {
	keyOn(channel: number, pitch: number, velocity: number): void;
	keyOff(channel: number, pitch: number, velocity: number): void;
	allNotesOff(hard: boolean): void;
}
export interface IFaustSvgDiagrams {
	/**
	 * Generates auxiliary files from Faust code. The output depends on the compiler options.
	 *
	 * @param name - the DSP's name
	 * @param code - Faust code
	 * @param args - compilation args
	 * @returns the svg diagrams as a filename - svg string map
	 */
	from(name: string, code: string, args: string): Record<string, string>;
}
export declare class FaustSvgDiagrams implements IFaustSvgDiagrams {
	private compiler;
	constructor(compiler: FaustCompiler);
	from(name: string, code: string, args: string): Record<string, string>;
}
export interface IFaustCmajor {
	/**
	 * Generates auxiliary files from Faust code. The output depends on the compiler options.
	 *
	 * @param name - the DSP's name
	 * @param code - Faust code
	 * @param args - compilation args
	 * @returns the Cmajor compiled string
	 */
	compile(name: string, code: string, args: string): string;
}
export declare class FaustCmajor implements IFaustCmajor {
	private fCompiler;
	constructor(compiler: FaustCompiler);
	compile(name: string, code: string, args: string): string;
}
export interface WavEncoderOptions {
	bitDepth: number;
	float?: boolean;
	symmetric?: boolean;
	shared?: boolean;
	sampleRate: number;
}
/**
 * Code from https://github.com/mohayonao/wav-encoder
 */
export declare class WavEncoder {
	static encode(audioBuffer: Float32Array[], options: WavEncoderOptions): ArrayBuffer | SharedArrayBuffer;
	private static writeHeader;
	private static writeData;
}
export interface WavDecoderOptions {
	symmetric?: boolean;
	shared?: boolean;
}
/**
 * Code from https://github.com/mohayonao/wav-decoder
 */
export declare class WavDecoder {
	static decode(buffer: ArrayBuffer, options?: WavDecoderOptions): {
		numberOfChannels: number;
		length: number;
		sampleRate: number;
		channelData: Float32Array[];
	};
	private static decodeFormat;
	private static decodeData;
	private static readPCM;
}
/** Read metadata and fetch soundfiles */
export declare class SoundfileReader {
	static get fallbackPaths(): string[];
	/**
	 * Extract the parent URL from an URL.
	 * @param url : the URL
	 * @returns : the parent URL
	 */
	private static getParentUrl;
	/**
	 * Convert an audio buffer to audio data.
	 *
	 * @param audioBuffer : the audio buffer to convert
	 * @returns : the audio data
	 */
	private static toAudioData;
	/**
	 * Extract the URLs from the metadata.
	 *
	 * @param dspMeta : the metadata
	 * @returns : the URLs
	 */
	static findSoundfilesFromMeta(dspMeta: FaustDspMeta): LooseFaustDspFactory["soundfiles"];
	/**
	 * Check if the file exists.
	 *
	 * @param url : the url of the file to check
	 * @returns : true if the file exists, otherwise false
	 */
	private static checkFileExists;
	/**
	 * Fetch the soundfile.
	 *
	 * @param url : the url of the soundfile
	 * @param audioCtx : the audio context
	 * @returns : the audio data
	 */
	private static fetchSoundfile;
	/**
	 * Load the soundfile.
	 *
	 * @param filename : the filename
	 * @param metaUrls : the metadata URLs
	 * @param soundfiles : the soundfiles
	 * @param audioCtx : the audio context
	 */
	private static loadSoundfile;
	/**
	 * Load the soundfiles, public API.
	 *
	 * @param dspMeta : the metadata
	 * @param soundfilesIn : the soundfiles
	 * @param audioCtx : the audio context
	 * @returns : the soundfiles
	 */
	static loadSoundfiles(dspMeta: FaustDspMeta, soundfilesIn: LooseFaustDspFactory["soundfiles"], audioCtx: BaseAudioContext): Promise<LooseFaustDspFactory["soundfiles"]>;
}
declare const FaustAudioWorkletNode_base: {
	new (context: BaseAudioContext, name: string, options?: AudioWorkletNodeOptions): AudioWorkletNode;
	prototype: AudioWorkletNode;
};
/**
 * Base class for Monophonic and Polyphonic AudioWorkletNode
 */
export declare class FaustAudioWorkletNode<Poly extends boolean = false> extends FaustAudioWorkletNode_base {
	#private;
	protected fJSONDsp: FaustDspMeta;
	protected fJSON: string;
	protected fInputsItems: string[];
	protected fOutputHandler: OutputParamHandler | null;
	protected fComputeHandler: ComputeHandler | null;
	protected fPlotHandler: PlotHandler | null;
	protected fUICallback: UIHandler;
	protected fDescriptor: FaustUIInputItem[];
	protected fCommunicator: FaustAudioWorkletNodeCommunicator;
	constructor(context: BaseAudioContext, name: string, factory: LooseFaustDspFactory, options?: Partial<FaustAudioWorkletNodeOptions<Poly>>);
	protected handleMessageAux: (e: MessageEvent) => void;
	private handleDeviceMotion;
	private handleDeviceOrientation;
	/** Setup accelerometer and gyroscope handlers */
	startSensors(): Promise<void>;
	stopSensors(): void;
	setOutputParamHandler(handler: OutputParamHandler | null): void;
	getOutputParamHandler(): OutputParamHandler | null;
	callOutputParamHandler(path: string, value: number): void;
	setComputeHandler(handler: ComputeHandler | null): void;
	getComputeHandler(): ComputeHandler | null;
	setPlotHandler(handler: PlotHandler | null): void;
	getPlotHandler(): PlotHandler | null;
	setupWamEventHandler(): void;
	getNumInputs(): number;
	getNumOutputs(): number;
	compute(inputs: Float32Array[], outputs: Float32Array[]): boolean;
	metadata(handler: MetadataHandler): void;
	midiMessage(data: number[] | Uint8Array): void;
	ctrlChange(channel: number, ctrl: number, value: number): void;
	pitchWheel(channel: number, wheel: number): void;
	keyOn(channel: number, pitch: number, velocity: number): void;
	keyOff(channel: number, pitch: number, velocity: number): void;
	get hasAccInput(): boolean;
	propagateAcc(accelerationIncludingGravity: NonNullable<DeviceMotionEvent["accelerationIncludingGravity"]>, invert?: boolean): void;
	get hasGyrInput(): boolean;
	propagateGyr(event: Pick<DeviceOrientationEvent, "alpha" | "beta" | "gamma">): void;
	setParamValue(path: string, value: number): void;
	getParamValue(path: string): number;
	getParams(): string[];
	getMeta(): FaustDspMeta;
	getJSON(): string;
	getUI(): FaustUIDescriptor;
	getDescriptors(): FaustUIInputItem[];
	start(): void;
	stop(): void;
	destroy(): void;
}
/**
 * Monophonic AudioWorkletNode
 */
export declare class FaustMonoAudioWorkletNode extends FaustAudioWorkletNode<false> implements IFaustMonoWebAudioDsp {
	onprocessorerror: (e: Event) => never;
	constructor(context: BaseAudioContext, options: Partial<FaustAudioWorkletNodeOptions<false>> & Pick<FaustAudioWorkletNodeOptions<false>, "processorOptions">);
}
/**
 * Polyphonic AudioWorkletNode
 */
export declare class FaustPolyAudioWorkletNode extends FaustAudioWorkletNode<true> implements IFaustPolyWebAudioDsp {
	private fJSONEffect;
	onprocessorerror: (e: Event) => never;
	constructor(context: BaseAudioContext, options: Partial<FaustAudioWorkletNodeOptions<true>> & Pick<FaustAudioWorkletNodeOptions<true>, "processorOptions">);
	keyOn(channel: number, pitch: number, velocity: number): void;
	keyOff(channel: number, pitch: number, velocity: number): void;
	allNotesOff(hard: boolean): void;
	getMeta(): FaustDspMeta;
	getJSON(): string;
	getUI(): FaustUIDescriptor;
}
declare const FaustScriptProcessorNode_base: {
	new (): ScriptProcessorNode;
	prototype: ScriptProcessorNode;
};
/**
 * Base class for Monophonic and Polyphonic ScriptProcessorNode
 */
export declare class FaustScriptProcessorNode<Poly extends boolean = false> extends FaustScriptProcessorNode_base {
	protected fDSPCode: Poly extends true ? FaustPolyWebAudioDsp : FaustMonoWebAudioDsp;
	protected fInputs: Float32Array[];
	protected fOutputs: Float32Array[];
	protected handleDeviceMotion: any;
	protected handleDeviceOrientation: any;
	init(instance: Poly extends true ? FaustPolyWebAudioDsp : FaustMonoWebAudioDsp): void;
	/** Start accelerometer and gyroscope handlers */
	startSensors(): Promise<void>;
	/** Stop accelerometer and gyroscope handlers */
	stopSensors(): void;
	compute(input: Float32Array[], output: Float32Array[]): boolean;
	setOutputParamHandler(handler: OutputParamHandler): void;
	getOutputParamHandler(): OutputParamHandler | null;
	callOutputParamHandler(path: string, value: number): void;
	setComputeHandler(handler: ComputeHandler): void;
	getComputeHandler(): ComputeHandler | null;
	setPlotHandler(handler: PlotHandler): void;
	getPlotHandler(): PlotHandler | null;
	getNumInputs(): number;
	getNumOutputs(): number;
	metadata(handler: MetadataHandler): void;
	midiMessage(data: number[] | Uint8Array): void;
	ctrlChange(chan: number, ctrl: number, value: number): void;
	pitchWheel(chan: number, value: number): void;
	keyOn(channel: number, pitch: number, velocity: number): void;
	keyOff(channel: number, pitch: number, velocity: number): void;
	setParamValue(path: string, value: number): void;
	getParamValue(path: string): number;
	getParams(): string[];
	getMeta(): FaustDspMeta;
	getJSON(): string;
	getDescriptors(): FaustUIInputItem[];
	getUI(): FaustUIDescriptor;
	start(): void;
	stop(): void;
	destroy(): void;
	get hasAccInput(): boolean;
	propagateAcc(accelerationIncludingGravity: NonNullable<DeviceMotionEvent["accelerationIncludingGravity"]>, invert?: boolean): void;
	get hasGyrInput(): boolean;
	propagateGyr(event: Pick<DeviceOrientationEvent, "alpha" | "beta" | "gamma">): void;
}
export declare class FaustMonoScriptProcessorNode extends FaustScriptProcessorNode<false> implements IFaustMonoWebAudioDsp {
}
export declare class FaustPolyScriptProcessorNode extends FaustScriptProcessorNode<true> implements IFaustPolyWebAudioDsp {
	keyOn(channel: number, pitch: number, velocity: number): void;
	keyOff(channel: number, pitch: number, velocity: number): void;
	allNotesOff(hard: boolean): void;
}
export interface GeneratorSupportingSoundfiles {
	/**
	 * Attach a map of id - audio data, call after `compile()` before `createNode()`
	 *
	 * @param soundfileMap a map of id - `AudioData` as an object where `AudioData` contains channel data as `audioBuffer: Float32Array[]` and `sampleRate: number`
	 */
	addSoundfiles(soundfileMap: Record<string, AudioData$1>): void;
	/**
	 * Get a list of soundfiles needed, call after `compile()`
	 */
	getSoundfileList(): string[];
}
export interface IFaustMonoDspGenerator extends GeneratorSupportingSoundfiles {
	/**
	 * Compile a monophonic DSP factory from given code.
	 *
	 * @param compiler - the Faust compiler
	 * @param name - the DSP name
	 * @param code - the DSP code
	 * @param args - the compilation parameters
	 * @returns the compiled factory or 'null' if failure
	 */
	compile(compiler: IFaustCompiler, name: string, code: string, args: string): Promise<{
		factory: FaustDspFactory | null;
		name?: string;
		meta?: FaustDspMeta;
	} | null>;
	/**
	 * Create a monophonic WebAudio node (either ScriptProcessorNode or AudioWorkletNode).
	 *
	 * @param context - the WebAudio context
	 * @param name - DSP name, can be used for processorName
	 * @param factory - default is the compiled factory
	 * @param sp - whether to compile a ScriptProcessorNode or an AudioWorkletNode
	 * @param bufferSize - the buffer size in frames to be used in ScriptProcessorNode only, since AudioWorkletNode always uses 128 frames
	 * @param processorName - AudioWorklet Processor name
	 * @param processorOptions - Additional AudioWorklet Processor options
	 * @returns the compiled WebAudio node or 'null' if failure
	 */
	createNode(context: BaseAudioContext, name?: string, factory?: LooseFaustDspFactory, sp?: boolean, bufferSize?: number, processorName?: string, processorOptions?: Record<string, any>): Promise<IFaustMonoWebAudioNode | null>;
	/**
	 * Create a monophonic WebAudio node (either ScriptProcessorNode or AudioWorkletNode).
	 *
	 * @param context - the WebAudio context
	 * @param fftUtils - should be an anonymous class with static methods, without any import from outside
	 * @param name - DSP name, can be used for processorName
	 * @param factory - default is the compiled factory
	 * @param fftOptions - initial FFT options
	 * @param processorName - AudioWorklet Processor name
	 * @param processorOptions - Additional AudioWorklet Processor options
	 * @returns the compiled WebAudio node or 'null' if failure
	 */
	createFFTNode(context: BaseAudioContext, fftUtils: typeof FFTUtils, name?: string, factory?: LooseFaustDspFactory, fftOptions?: Partial<FaustFFTOptionsData>, processorName?: string, processorOptions?: Record<string, any>): Promise<FaustMonoAudioWorkletNode | null>;
	/**
	 * Create a monophonic Offline processor.
	 *
	 * @param sampleRate - the sample rate in Hz
	 * @param bufferSize - the buffer size in frames
	 * @param factory - default is the compiled factory
	 * @param context - if this exists, will be used to fetch soundfiles online
	 * @returns the compiled processor or 'null' if failure
	 */
	createOfflineProcessor(sampleRate: number, bufferSize: number, factory?: LooseFaustDspFactory, context?: BaseAudioContext): Promise<IFaustMonoOfflineProcessor | null>;
	/**
	 * Get DSP JSON description with its UI and metadata as object.
	 *
	 * @return the DSP JSON description as object
	 */
	getMeta(): FaustDspMeta;
	/**
	 * Get DSP JSON description with its UI and metadata.
	 *
	 * @return the DSP JSON description
	 */
	getJSON(): string;
	/**
	 * Get DSP UI description.
	 *
	 * @return the DSP UI description
	 */
	getUI(): FaustUIDescriptor;
}
export interface IFaustPolyDspGenerator extends GeneratorSupportingSoundfiles {
	/**
	 * Compile a monophonic DSP factory from given code.
	 *
	 * @param compiler - the Faust compiler
	 * @param name - the DSP name
	 * @param dspCode - the DSP code ('dspCode' can possibly contain an integrated effect)
	 * @param args - the compilation parameters
	 * @param effectCode - optional effect DSP code
	 * @returns the compiled factory or 'null' if failure
	 */
	compile(compiler: IFaustCompiler, name: string, dspCode: string, args: string, effectCode?: string): Promise<{
		voiceFactory: FaustDspFactory | null;
		effectFactory?: FaustDspFactory | null;
	} | null>;
	/**
	 * Create a polyphonic WebAudio node (either ScriptProcessorNode or AudioWorkletNode).
	 *
	 * @param context the WebAudio context
	 * @param voices - the number of voices
	 * @param name - AudioWorklet Processor name
	 * @param voiceFactory - the Faust factory for voices, either obtained with a compiler (createDSPFactory) or loaded from files (loadDSPFactory)
	 * @param mixerModule - the wasm Mixer module (loaded from 'mixer32.wasm' or 'mixer64.wasm' files located in the 'faustwasm' package)
	 * @param effectFactory - the Faust factory for the effect, either obtained with a compiler (createDSPFactory) or loaded from files (loadDSPFactory)
	 * @param sp - whether to compile a ScriptProcessorNode or an AudioWorkletNode
	 * @param bufferSize - the buffer size in frames to be used in ScriptProcessorNode only, since AudioWorkletNode always uses 128 frames
	 * @param processorOptions - Additional AudioWorklet Processor options
	 * @returns the compiled WebAudio node or 'null' if failure
	 */
	createNode(context: BaseAudioContext, voices: number, name?: string, voiceFactory?: LooseFaustDspFactory, mixerModule?: WebAssembly.Module, effectFactory?: LooseFaustDspFactory | null, sp?: boolean, bufferSize?: number, processorName?: string, processorOptions?: Record<string, any>): Promise<IFaustPolyWebAudioNode | null>;
	/**
	 * Create a monophonic Offline processor.
	 *
	 * @param sampleRate - the sample rate in Hz
	 * @param bufferSize - the buffer size in frames
	 * @param voiceFactory - the Faust factory for voices, either obtained with a compiler (createDSPFactory) or loaded from files (loadDSPFactory)
	 * @param mixerModule - the wasm Mixer module (loaded from 'mixer32.wasm' or 'mixer64.wasm' files)
	 * @param effectFactory - the Faust factory for the effect, either obtained with a compiler (createDSPFactory) or loaded from files (loadDSPFactory)
	 * @param context - if this exists, will be used to fetch soundfiles online
	 * @returns the compiled processor or 'null' if failure
	 */
	createOfflineProcessor(sampleRate: number, bufferSize: number, voices: number, voiceFactory?: LooseFaustDspFactory, mixerModule?: WebAssembly.Module, effectFactory?: LooseFaustDspFactory | null, context?: BaseAudioContext): Promise<IFaustPolyOfflineProcessor | null>;
	/**
	 * Get DSP JSON description with its UI and metadata as object.
	 *
	 * @return the DSP JSON description as object
	 */
	getMeta(): FaustDspMeta;
	/**
	 * Get DSP JSON description with its UI and metadata.
	 *
	 * @return the DSP JSON description
	 */
	getJSON(): string;
	/**
	 * Get DSP UI description.
	 *
	 * @return the DSP UI description
	 */
	getUI(): FaustUIDescriptor;
}
export declare class FaustMonoDspGenerator implements IFaustMonoDspGenerator {
	private static gWorkletProcessors;
	name: string;
	factory: FaustDspFactory | null;
	constructor();
	compile(compiler: IFaustCompiler, name: string, code: string, args: string): Promise<this | null>;
	addSoundfiles(soundfileMap: Record<string, AudioData$1>): void;
	getSoundfileList(): string[];
	createNode<SP extends boolean = false>(context: BaseAudioContext, name?: string, factory?: LooseFaustDspFactory, sp?: SP, bufferSize?: number, processorName?: string, processorOptions?: Record<string, any>): Promise<SP extends true ? FaustMonoScriptProcessorNode | null : FaustMonoAudioWorkletNode | null>;
	createFFTNode(context: BaseAudioContext, fftUtils: typeof FFTUtils, name?: string, factory?: LooseFaustDspFactory, fftOptions?: Partial<FaustFFTOptionsData>, processorName?: string, processorOptions?: Record<string, any>): Promise<FaustMonoAudioWorkletNode | null>;
	createAudioWorkletProcessor(name?: string, factory?: LooseFaustDspFactory, processorName?: string): Promise<{
		new (options: AudioWorkletNodeOptions): AudioWorkletProcessor;
		prototype: AudioWorkletProcessor;
		parameterDescriptors: AudioParamDescriptor[];
	}>;
	createOfflineProcessor(sampleRate: number, bufferSize: number, factory?: LooseFaustDspFactory, context?: BaseAudioContext): Promise<FaustMonoOfflineProcessor>;
	getMeta(): any;
	getJSON(): string;
	getUI(): any;
}
export declare class FaustPolyDspGenerator implements IFaustPolyDspGenerator {
	private static gWorkletProcessors;
	name: string;
	voiceFactory: FaustDspFactory | null;
	effectFactory: FaustDspFactory | null;
	mixerBuffer: Uint8Array;
	mixerModule: WebAssembly.Module;
	constructor();
	compile(compiler: IFaustCompiler, name: string, dspCodeAux: string, args: string, effectCodeAux?: string): Promise<this | null>;
	addSoundfiles(soundfileMap: Record<string, AudioData$1>): void;
	getSoundfileList(): string[];
	createNode<SP extends boolean = false>(context: BaseAudioContext, voices: number, name?: string, voiceFactory?: LooseFaustDspFactory, mixerModule?: WebAssembly.Module, effectFactory?: LooseFaustDspFactory | null, sp?: SP, bufferSize?: number, processorName?: string, processorOptions?: {}): Promise<SP extends true ? FaustPolyScriptProcessorNode | null : FaustPolyAudioWorkletNode | null>;
	createAudioWorkletProcessor(name?: string, voiceFactory?: LooseFaustDspFactory, effectFactory?: LooseFaustDspFactory | null, processorName?: string): Promise<{
		new (options: AudioWorkletNodeOptions): AudioWorkletProcessor;
		prototype: AudioWorkletProcessor;
		parameterDescriptors: AudioParamDescriptor[];
	}>;
	createOfflineProcessor(sampleRate: number, bufferSize: number, voices: number, voiceFactory?: LooseFaustDspFactory, mixerModule?: WebAssembly.Module, effectFactory?: LooseFaustDspFactory | null, context?: BaseAudioContext): Promise<FaustPolyOfflineProcessor>;
	getMeta(): FaustDspMeta;
	getJSON(): string;
	getUI(): FaustUIDescriptor;
}

export {
	AudioData$1 as AudioData,
};

export {};
